//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Reflection;
using System.Reflection.Emit;
using System.Runtime.InteropServices;

namespace TypeLibraryConversion
{
	/// <summary>
	/// Podsumowanie dla COMTypeLibrary.
	/// </summary>
	class COMTypeLibrary
	{
		private enum RegKind
		{
			RegKind_Default = 0,
			RegKind_Register = 1,
			RegKind_None = 2
		}
   
		[ DllImport( "oleaut32.dll", CharSet = CharSet.Unicode, PreserveSig = false )]
		private static extern void LoadTypeLibEx( String strTypeLibName, RegKind regKind, 
			[ MarshalAs( UnmanagedType.Interface )] out Object typeLib );
   
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			Object typeLib;
			LoadTypeLibEx( "COMTypes.dll", RegKind.RegKind_None, out typeLib ); 
      
			if( typeLib == null )
			{
				Console.WriteLine( "Dziaanie LoadTypeLibEx nie powiodo si." );
				return;
			}
         
			TypeLibConverter c = new TypeLibConverter();
			ConversionEventHandler eventHandler = new ConversionEventHandler();
			AssemblyBuilder asm = c.ConvertTypeLibToAssembly( typeLib, "Interop.COMTypes.dll", 0, eventHandler, null, null, null, new Version("1.0.0.0") );
			asm.Save( "Interop.COMTypes.dll" );
		}
	}
	public class ConversionEventHandler : ITypeLibImporterNotifySink
	{
		public void ReportEvent( ImporterEventKind eventKind, int eventCode, string eventMsg )
		{
			// Proste zgoszenie o wywoaniu tej metody.
			// Przypomina to opcj /verbose narzdzia tlbimp.
			Console.WriteLine("ReportEvent {0}: {1}", eventKind, eventMsg);
		}
   
		public Assembly ResolveRef( object typeLib )
		{
			// Rozwizanie odwoa i zwrcenie waciwego podzespou.
			Console.WriteLine("ResolveRef");
			return null; 
		}   
	}
}
